#!/usr/bin/env python
# -*- coding: utf-8 -*-

# An ES Tools replacement for CS:S by fratacos
# Version 0.76

#[Fixed]
#disabled some functions for the recent SPE update

#[Known Issues]
#Restriction behavior is a bit different from the original
#All commands should be written in lower-cases (ex: est_spawn, NOT est_Spawn)

import psyco
psyco.full()

import time
import random
import os
import math
import operator

import es
import spe
import gamethread
import playerlib

hooked_event_var = 0
round_count = 0
round_interval = 0
timer = 0
gametime = 0
curtimed = 0
starttime = time.time()
buttons_list = {}
regclientcmd_list = []
restrict_list = {}
restrict_weapon_list = {}
modplayerweapon_list = {}
modweapon_list = {}
weaponmod_list = {}
regeventblock_list = {}
rocket_list = {}
file_list = {}
file_handle = 0
escort_list = {}
bought_list = {}
sayhook_list = {}
getchat_list = {}
count_rescued = 0
thetrigger = 0
allweapons = ("weapon_ak47", "weapon_aug", "weapon_awp", "weapon_c4", "weapon_deagle", "weapon_elite", "weapon_famas", "weapon_fiveseven", "weapon_flashbang", "weapon_g3sg1", "weapon_galil", "weapon_glock", "weapon_hegrenade", "weapon_knife", "weapon_m249", "weapon_m3", "weapon_m4a1", "weapon_mac10", "weapon_mp5navy", "weapon_p228", "weapon_p90", "weapon_scout", "weapon_sg550", "weapon_sg552", "weapon_smokegrenade", "weapon_tmp", "weapon_ump45", "weapon_usp", "weapon_xm1014")
allprimary = ("weapon_ak47", "weapon_aug", "weapon_awp", "weapon_famas", "weapon_g3sg1", "weapon_galil", "weapon_m249", "weapon_m3", "weapon_m4a1", "weapon_mac10", "weapon_mp5navy", "weapon_p90", "weapon_scout", "weapon_sg550", "weapon_sg552", "weapon_tmp", "weapon_ump45", "weapon_xm1014")
allsecondary = ("weapon_deagle", "weapon_elite", "weapon_fiveseven", "weapon_glock", "weapon_p228", "weapon_usp")
ammo_list = { "weapon_p228":"009", "weapon_deagle":"001", "weapon_m4a1":"003", "weapon_tmp":"006", "weapon_aug":"002", "weapon_smokegrenade":"013", "weapon_mac10":"008", "weapon_m3":"007", "weapon_ak47":"002", "weapon_m249":"004", "weapon_fiveseven":"010", "weapon_xm1014":"007", "weapon_flashbang":"012", "weapon_glock":"006", "weapon_p90":"010", "weapon_usp":"008", "weapon_ump45":"008", "weapon_awp":"005", "weapon_scout":"002", "weapon_elite":"006", "weapon_c4":None, "weapon_famas":"003", "weapon_galil":"003", "weapon_hegrenade":"011", "weapon_mp5navy":"006", "weapon_knife":None, "weapon_g3sg1":"002", "weapon_sg550":"003", "weapon_sg552":"003", }
allflags = ("gamedll", "protected", "sponly", "notify", "cheat", "userinfo", "unlogged", "replicated")
pyfilter = ("#alive", "#all", "#bot", "#ct", "#dead", "#human", "#spec", "#t", "#un")
filter_table = (("t","#t"), ("c","#ct"), ("3","#ct"), ("2","#t"), ("s","#spec"), ("1","#spec"), ("u","#un"), ("h","#human"), ("b","#bot"), ("l","#alive"), ("a","#all"), ("d","#dead"))
weaponmod_default = {"recoil":0, "damage0":0, "damage1":0, "damage2":0, "damage3":0, "damage4":0, "damage5":0, "damage6":0, "damage7":0, "damageaction":"+", "punchback":0, "speed":1.0, "auto":0}
in_buttons = {"attack":1<<0, "jump":1<<1, "duck":1<<2, "forward":1<<3, "back":1<<4, "use":1<<5, "cancel":1<<6, "left":1<<7, "right":1<<8, "moveleft":1<<9, "moveright":1<<10, "attack2":1<<11, "run":1<<12, "reload":1<<13, "alt1":1<<14, "alt2":1<<15, "score":1<<16, "speed":1<<17, "walk":1<<18, "zoom":1<<19, "weapon1":1<<20, "weapon2":1<<21, "bullrush":1<<22, "grenade1":1<<23, "grenade2":1<<24}
offsets = {"m_afButtonDisabled":0x0A38, "m_iFrags":0x0CDC, "m_iDeaths":0x0CE0, "m_nButtons":0x0A28, "m_autoKickDisabled":0x0EE4, "m_iName":0x0108}
# is this work for Macintosh too?
if os.name != "nt":
	for key in offsets:
		offsets[key] += 20

def load():
	es.addons.registerClientCommandFilter(clientcommandfilter)
	es.addons.registerSayFilter(sayfilter)
	if "registerPreHook" in dir(spe):
		spe.registerPreHook("player_disconnect", pre_player_disconnect)
		spe.registerPreHook("player_hurt", pre_player_hurt)
		spe.registerPreHook("weapon_fire", pre_weapon_fire)
		spe.registerPreHook("item_pickup", pre_item_pickup)
	es.addons.registerTickListener(ticklistener)

def unload():
	es.addons.unregisterTickListener(ticklistener)
	if "unregisterPreHook" in dir(spe):
		spe.unregisterPreHook("item_pickup", pre_item_pickup)
		spe.unregisterPreHook("weapon_fire", pre_weapon_fire)
		spe.unregisterPreHook("player_hurt", pre_player_hurt)
		spe.unregisterPreHook("player_disconnect", pre_player_disconnect)
	es.addons.unregisterSayFilter(sayfilter)
	es.addons.unregisterClientCommandFilter(clientcommandfilter)

def adddownload(param):
	es.stringtable("downloadables", param)
def armor(users, param, value):
	v = int(value)
	for userid in getusers(users):
		if param in ("+", "-"):
			now = es.getplayerprop(userid, "CCSPlayer.m_ArmorValue")
			if param == "+":
				now += v
			if param == "-":
				now -= v
			v = now
		if param in ("=", "+", "-"):
			es.setplayerprop(userid, "CCSPlayer.m_ArmorValue", v)
def armoradd(users, value):
	armor(users, "+", value)
def ban(users, time, reason = ""):
	flag = 0
	if reason == "":
		flag = 1
	for userid in getusers(users):
		if flag:
			es.ServerCommand("banid %s %s kick" % (time, userid))
		else:
			es.ServerCommand("banid %s %s" % (time, userid))
			es.ServerCommand("kickid %s %s" % (userid, reason))
def burn(users, time = 0):
	t = int(time)
	trigger = gettrigger()
	for userid in getusers(users):
		index = es.getindexfromhandle(es.getplayerhandle(userid))
		es.entitysetvalue(index, "targetname", index)
		if t != 0:
			es.fire(trigger, index, "IgniteLifetime", t)
		else:
			es.fire(trigger, index, "Ignite")
def cash(users, param, value):
	v = int(value)
	for userid in getusers(users):
		if param in "+-":
			now = es.getplayerprop(userid, "CCSPlayer.m_iAccount")
			if param == "+":
				now += v
			if param == "-":
				now -= v
			v = now
		if param in "=+-":
			es.setplayerprop(userid, "CCSPlayer.m_iAccount", v)
def cashadd(users, value):
	cash(users, "+", value)
def cexec(users, command):
	for userid in getusers(users):
		es.ServerCommand("es_xsexec %s %s" % (userid, command))
def closefile(fileid):
	global file_list
	id = int(fileid)
	if not id in file_list:
		return
	del file_list[id]
def countents(name):
	return len(es.getEntityIndexes(name))
def countlines(fileid):
	global file_list
	id = int(fileid)
	if not id in file_list:
		return
	no = 0
	for line in file_list[id][2]:
		no += 1
	return no
def credits():
	es.ServerCommand("est_credits")
def csay(users, text):
	es.usermsg("create", "centermsg", "TextMsg")
	es.usermsg("write", "byte", "centermsg", 4)
	es.ServerVar("temp").set(text.replace("\\", "\\\\"))
	es.usermsg("writev", "string", "centermsg", "temp")
	for userid in getusers(users):
		es.usermsg("send", "centermsg", userid)
	es.usermsg("delete", "centermsg")
def curtime_init():
	global timer, gametime
	timer = time.time()
	temp = es.createentity("env_particlesmokegrenade")
	gametime = es.getindexprop(temp, "ParticleSmokeGrenade.m_flSpawnTime")
	trigger = gettrigger()
	if trigger == 0:
		spe.removeEntityByIndex(temp)
	else:
		es.fire(trigger, temp, "Kill")
def curtime():
	global timer, gametime, curtimed
	if curtimed == 0:
		return gametime
	if timer == 0:
		curtime_init()
		return gametime
	return gametime + time.time() - timer
def cvaraddflag(cvar, gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated):
	global allflags
	data = (gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated)
	for i, item in enumerate(data):
		if int(item):
			es.flags("add", allflags[i], cvar)
def cvardelflag(cvar, gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated):
	global allflags
	data = (gamedll, protected, sponly, notify, cheat, userinfo, unlogged, replicated)
	for i, item in enumerate(data):
		if int(item):
			es.flags("remove", allflags[i], cvar)
def damage(source, target, value):
	if str(source) != "0":
		for userid in getusers(source):
			break
		else:
			return
		source = userid
		targets = [es.getindexfromhandle(es.getplayerhandle(x)) for x in getusers(target)]
		for user in targets:
			es.entitysetvalue(user, "targetname", "damagetarget")
		index = es.createentity("point_hurt")
		es.entitysetvalue(index, "damage", value)
		es.entitysetvalue(index, "damagetype", 32)
		es.entitysetvalue(index, "targetname", index)
		es.entitysetvalue(index, "classname", getgun(source))
		es.fire(source, index, "addoutput", "DamageTarget damagetarget")
		es.fire(source, index, "Hurt")
		es.fire(source, index, "Kill")
		gamethread.delayed(0.1, damage_delayed, targets)
		return
	for userid in getusers(target):
		source = userid
		user = es.getindexfromhandle(es.getplayerhandle(userid))
		es.entitysetvalue(user, "targetname", "damagetarget")
		index = es.createentity("point_hurt")
		es.entitysetvalue(index, "damage", value)
		es.entitysetvalue(index, "damagetype", 32)
		es.entitysetvalue(index, "targetname", index)
		es.fire(source, index, "addoutput", "DamageTarget damagetarget")
		es.fire(source, index, "Hurt")
		es.fire(source, index, "Kill")
		es.entitysetvalue(user, "targetname", "mrnothing")
def damage_delayed(targets):
	for user in targets:
		es.entitysetvalue(user, "targetname", "mrnothing")
def deafen(users, total, percent, fadeout, fadeback):
	for userid in getusers(users):
		es.fadevolume(userid, percent, fadeout, total, fadeback)
def deathadd(users, value):
	deaths(users, "+", value)
def deaths(users, param, v):
	offset = getoffsetvalue("m_iDeaths")
	value = int(v)
	if param == "=":
		for userid in getusers(users):
			pplayer = spe.getPlayer(userid)
			if not pplayer:
				continue
			spe.setLocVal("i", pplayer + offset, value)
	elif param in ["+", "-"]:
		if param == "-":
			value = -value
		for userid in getusers(users):
			pplayer = spe.getPlayer(userid)
			if not pplayer:
				continue
			temp = spe.getLocVal("i", pplayer + offset)
			spe.setLocVal("i", pplayer + offset, temp + value)
def deathset(users, value):
	deaths(users, "=", value)
def dissolve(param, type=0, time=0, origin="0,0,0", magnitude=1):
	t = int(time)
	if t == 0:
		dissolve_delayed(param, type, origin, magnitude)
	else:
		gamethread.delayed(t, dissolve_delayed, (param, type, origin, magnitude))
def dissolve_delayed(param, type, origin, magnitude):
	trigger = gettrigger()
	index = es.createentity("env_entity_dissolver", trigger)
	es.entitysetvalue(index, "target", param)
	es.entitysetvalue(index, "magnitude", magnitude)
	es.entitysetvalue(index, "dissolvetype", type)
	es.spawnentity(index)
	es.setindexprop(index, "CEntityDissolve.m_vDissolverOrigin", origin)
	es.fire(trigger, trigger, "Dissolve")
	es.fire(trigger, trigger, "Kill")
def deleteragdolls(users = 0):
	if str(users) == "0":
		gamethread.delayed(0.25, es.fire, (gettrigger(), "cs_ragdoll", "Kill"))
		return
	handles = []
	for userid in getusers(users):
		handles.append(es.getplayerhandle(userid))
	ragdolls = es.getEntityIndexes("cs_ragdoll")
	for index in ragdolls:
		if es.getindexprop(index, "CCSRagdoll.m_hPlayer") in handles:
			es.setentityname(index, "theragdoll")
	gamethread.delayed(0.25, es.fire, (gettrigger(), "theragdoll", "Kill"))
def dropweapon(users, param):
	global allweapons
	for userid in getusers(users):
		name = getweaponinfo(userid, param)
		for item in name:
			if item in allweapons:
				spe.dropWeapon(userid, item)
def drug(users, time = -1):
	t = int(time)
	for userid in getusers(users):
		if t != 0:
			es.cexec(userid, "r_screenoverlay Effects/tp_eyefx/tp_eyefx.vmt")
		if t >= 0:
			gamethread.delayed(t, es.cexec, (userid, "r_screenoverlay null"))
def drunk(users, time = -1):
	global round_count
	t = int(time)
	drunk_loop(0, t, getusers(users), 90, 0, int(round_count))
def drunk_loop(count, time, users, fov, ang, round):
	global round_count
	global round_interval
	if (round != round_count) or (time >= 0 and count / 5 > time):
		for userid in users:
			player = playerlib.getPlayer(userid)
			angle = player.getViewAngle()
			es.setang(userid, angle[0], angle[1], 0)
			es.setplayerprop(userid, "CBasePlayer.m_iFOV", 90)
		return
	flag = 0
	for userid in users:
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if dead:
			player = playerlib.getPlayer(userid)
			angle = player.getViewAngle()
			es.setang(userid, angle[0], angle[1], 0)
			es.setplayerprop(userid, "CBasePlayer.m_iFOV", 90)
			continue
		flag = 1
		ang += (-15, -10, 10, 15)[random.randint(0, 3)]
		if ang < -60: ang = -60
		if ang > 60: ang = 60
		player = playerlib.getPlayer(userid)
		angle = player.getViewAngle()
		es.setang(userid, angle[0], angle[1], ang)
		fov += (-15, -10, -5, 5, 10, 15)[random.randint(0, 5)]
		if fov < 30: fov = 30
		if fov > 150: fov = 150
		es.setplayerprop(userid, "CBasePlayer.m_iFOV", fov)
	if flag:
		gamethread.delayed(0.2, drunk_loop, (count + 1, time, users, fov, ang, round))
def endround(time, reason):
	r = int(reason)
	if not (0 < r and r < 17):
		return
	gamethread.delayed(int(time), endround_delayed, r - 1)
def endround_delayed(condition):
	index = es.getentityindex("info_map_parameters")
	created = False
	if index == -1:
		index = es.createentity("info_map_parameters")
		created = True
	trigger = gettrigger()
	es.fire(trigger, "info_map_parameters", "FireWinCondition", condition)
	if created:
		es.fire(trigger, "info_map_parameters", "Kill")
def entphyspush(index, x, y, z):
	es.fire(gettrigger(), "prop_physics_multiplayer", "Wake")
	gamethread.delayed(0.1, es.physics, ("active", "setvelocity", index, "%f,%f,%f" % (float(x), float(y), float(z))))
def entpushto(index, x, y, z, force):
	source = es.getindexprop(index, "CBaseEntity.m_vecOrigin").split(",")
	base = (float(x) - float(source[0]), float(y) - float(source[1]), float(z) - float(source[2]))
	f = float(force)
	es.fire(gettrigger(), "prop_physics_multiplayer", "Wake")
	gamethread.delayed(0.1, es.physics, ("active", "applyforce", index, "%f,%f,%f" % (base[0] * f, base[1] * f, base[2] * f, )))
def entteleport(index, x, y, z):
	es.setentityname(index, "theentity")
	es.entitysetvalue(index, "origin", "%s,%s,%s," % (str(x), str(y), str(z)))
def extinguish(users):
	trigger = gettrigger()
	for userid in getusers(users):
		index = es.getindexfromhandle(es.getplayerhandle(userid))
		es.entitysetvalue(index, "targetname", index)
		es.fire(trigger, index, "IgniteLifetime", 0)
def fade(users, type, fadetime, totaltime, r, g, b, a):
	t = int(type)
	if t == 1:
		type = 2
	elif t == 0:
		type = 1
	else:
		type = 8 + 16
	es.usermsg("create", "fade", "Fade")
	es.usermsg("write", "short", "fade", float(fadetime) * 1000)
	es.usermsg("write", "short", "fade", float(totaltime) * 1000)
	es.usermsg("write", "short", "fade", int(type))
	es.usermsg("write", "byte", "fade", int(r))
	es.usermsg("write", "byte", "fade", int(g))
	es.usermsg("write", "byte", "fade", int(b))
	es.usermsg("write", "byte", "fade", int(a))
	for userid in getusers(users):
		es.usermsg("send", "fade", userid)
	es.usermsg("delete", "fade")
def fileexists(path):
	test = "%s/cstrike/%s" % (os.getcwd(), path)
	if not os.path.exists(test): return 0
	if not os.path.isabs(test): return -1
	if not os.path.isfile(test): return -1
	if os.path.islink(test): return -1
	return 1
def freeze(users, param = 1):
	# we can't bit operate directly because movetype isn't always positive
	for userid in getusers(users):
		movetype = es.getplayerprop(userid, "CBaseEntity.movetype")
		if not movetype:
			continue
		if str(param) == "1":
			if movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype - 2)
		else:
			if not movetype & 2:
				es.setplayerprop(userid, "CBaseEntity.movetype", movetype + 2)
def getammo(users, param):
	global ammo_list
	for userid in getusers(users):
		info = getweaponinfo(userid, param)
		for name in info:
			if name == "weapon_none":
				continue
			no = ammo_list[name]
			return es.getplayerprop(userid, "CBasePlayer.localdata.m_iAmmo.%s" % no)
	return None
def getarmor(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CCSPlayer.m_ArmorValue")
	return None
def getchat(users):
	global getchat_list
	for userid in getusers(users):
		return getchat_list.setdefault(userid, "")
def getclipammo(users, param):
	for userid in getusers(users):
		for index in getweaponinfo(userid, param, 1):
			return es.getindexprop(index, "CBaseCombatWeapon.LocalWeaponData.m_iClip1")
	return None
def getdeaths(users):
	offset = getoffsetvalue("m_iDeaths")
	for userid in getusers(users):
		pplayer = spe.getPlayer(userid)
		if not pplayer:
			continue
		return spe.getLocVal("i", pplayer + offset)
def getentclassname(index):
	return es.entitygetvalue(index, "classname")
def getentityindex(users, classname):
	# I believe this command and getweaponindex are identical
	return getweaponindex(users, classname)
def getentname(index):
	# does not support unicode string
	offset = getoffsetvalue("m_iName")
	pentity = spe.getEntityOfIndex(index)
	if not pentity:
		return
	v = spe.getLocVal("i", pentity + offset)
	text = ""
	# is (4 * 64 = 256) bytes enough?
	for i in xrange(64):
		t = spe.getLocVal("i", v)
		while t:
			x = t % 256
			if x <= 0:
				break
			text += chr(x)
			t /= 256
		if x <= 0:
			break
		v += 4
	return text
def getescort(users):
	global escort_list
	for userid in getusers(users):
		return escort_list.setdefault(userid, 0)
	return 0
def geteventinfo(param):
	return es.event_var[param]
def geteyecoord(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getEyeLocation()
def getfb(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getFB()
	return None
def getgravity(users):
	for userid in getusers(users):
		index = es.getindexfromhandle(es.getplayerhandle(userid))
		return es.entitygetvalue(index, "gravity")
	return None
def getgun(users):
	for userid in getusers(users):
		handle = es.getplayerprop(userid, "CBaseCombatCharacter.m_hActiveWeapon")
		index = es.getindexfromhandle(handle)
		return es.entitygetvalue(index, "classname")
	return "weapon_none"
def getguncoord(users):
	eye = geteyecoord(users)
	if eye == None:
		return None
	gun = []
	for item in eye:
		gun.append(item)
	gun[2] += 20.0
	return gun
def gethe(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getHE()
	return None
def gethealth(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CBasePlayer.m_iHealth")
	return None
def getindex(users):
	for userid in getusers(users):
		return es.getindexfromhandle(es.getplayerhandle(userid))
	return None
def getip(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).address
def getkills(users):
	offset = getoffsetvalue("m_iFrags")
	for userid in getusers(users):
		pplayer = spe.getPlayer(userid)
		if not pplayer:
			continue
		return spe.getLocVal("i", pplayer + offset)
def getline(fileid, lineno):
	global file_list
	id = int(fileid)
	if not id in file_list: return
	theno = int(lineno)
	no = 0
	for line in file_list[id][2]:
		no += 1
		if no == theno:
			break
	return line
def getname(users):
	for userid in getusers(users):
		return es.getplayername(userid)
	return None
def getnamedoffset(index, property):
	pentity = spe.getEntityOfIndex(index)
	if not pentity:
		return
	return pentity + es.getpropoffset(property)
def getoffset(index, property):
	offset = es.getpropoffset(property)
	if offset <= 0 or offset > 32768:
		return None
	type = es.getproptype(property)
	if type <= 3:
		return es.getentitypropoffset(index, offset, type)
	# TODO: implement other DPT_ types
	return spe.getLocVal("i", pentity + offset)
def getplayerdistance(target1, target2):
	for t1 in getusers(target1):
		break
	else:
		return
	for t2 in getusers(target2):
		break
	else:
		return
	vec1 = [float(x) for x in es.getplayerprop(t1, "CBaseEntity.m_vecOrigin").split(",")]
	vec2 = [float(x) for x in es.getplayerprop(t2, "CBaseEntity.m_vecOrigin").split(",")]
	vec = map(operator.sub, vec1, vec2)
	distance = (vec[0]**2 + vec[1]**2 + vec[2]**2)**0.5
	azimuth = math.degrees(math.atan2(vec1[1] - vec2[1], vec1[0] - vec2[0])) + 180
	elevation = math.degrees(math.atan2(vec1[2] - vec2[2], distance)) + 360
	return distance, azimuth, elevation
def getplayerlocation(users):
	for userid in getusers(users):
		break
	else:
		return
	return es.getplayerprop(userid, "CBasePlayer.m_szLastPlaceName")
def getprimary(users):
	for userid in getusers(users):
		return getweaponinfo(userid, 1)
def getsecondary(users):
	for userid in getusers(users):
		return getweaponinfo(userid, 2)
def getsg(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getSG()
def getslot(users, param):
	if not str(param) in ("1", "2", "3", "4"):
		return
	for userid in getusers(users):
		return getweaponinfo(userid, param)
def getsteam(users):
	for userid in getusers(users):
		return es.getplayersteamid(userid)
	return None
def getteam(users):
	for userid in getusers(users):
		return es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")
	return None
def getuserid(users):
	for userid in getusers(users):
		return userid
	return None
def getviewangle(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).getViewAngle()
def getviewcoord(users):
	for userid in getusers(users):
		es.prop_dynamic_create(userid, "props_c17/tv_monitor01_screen.mdl")
		index = es.getInt("eventscripts_lastgive")
		es.setentityname(index, index)
		coord = [float(x) for x in es.getindexprop(index, "CBaseEntity.m_vecOrigin").split(",")]
		es.fire(gettrigger(), index, "Kill")
		return coord
def getviewprop(users):
	for userid in getusers(users):
		break
	else:
		return 0
	es.entsetname(userid, "lookingat")
	for index in es.getEntityIndexes():
 		if es.entitygetvalue(index, "targetname") == "lookingat":
			es.entitysetvalue(index, "targetname", "")
			return es.getUseridList()[index - 1]
	return 0
def getviewplayer(users):
	for userid in getusers(users):
		break
	else:
		return 0
	es.entsetname(userid, "lookingat")
	for index in es.getEntityIndexes("player"):
 		if es.entitygetvalue(index, "targetname") == "lookingat":
			es.entitysetvalue(index, "targetname", "")
			return es.getUseridList()[index - 1]
	return 0
def getweaponindex(users, param):
	for userid in getusers(users):
		return getweaponinfo(userid, param, 1)
def give(users, param):
	for userid in getusers(users):
		es.ServerCommand("es_xgive %s %s" % (userid, param))
def god(users, param = 1):
	for userid in getusers(users):
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if not dead:
			if str(param) == "1":
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 0)
			else:
				es.setplayerprop(userid, "CBasePlayer.m_lifeState", 512)
def hasdefuser(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).hasDefuser()
	return 0
def hashelmet(users):
	for userid in getusers(users):
		return playerlib.getPlayer(userid).hasHelmet()
	return 0
def haskevlar(users):
	for userid in getusers(users):
		if es.getplayerprop(userid, "CCSPlayer.m_ArmorValue") > 0:
			return 1
		else:
			return 0
	return 0
def health(users, param, value = 0):
	v = int(value)
	if v == 0 and str(param) not in ("=", "+", "-"):
		v = int(param)
		param = "="
	flag = 0
	for userid in getusers(users):
		vv = v
		if param in ("+", "-"):
			now = es.getplayerprop(userid, "CBasePlayer.m_iHealth")
			if now == None:
				continue
			vv = now
			if param == "+":
				vv += v
			if param == "-":
				vv -= v
		if param in ("=", "+", "-"):
			es.setplayerprop(userid, "CBasePlayer.m_iHealth", vv)
			es.setplayerprop(userid, "CBasePlayer.m_iMaxHealth", vv)
def healthadd(users, value):
	health(users, "+", value)
def help(text = ""):
	if text == "":
		es.ServerCommand("est_help")
	else:
		es.ServerCommand("est_help %s" % text)
def hookkey(users, key):
	global in_buttons
	offset = getoffsetvalue("m_afButtonDisabled")
	if not key in in_buttons:
		return
	value = in_buttons[key]
	if str(users) == "-1":
		obj = es.getUseridList()
	else:
		obj = getusers(users)
	for userid in obj:
		pplayer = spe.getPlayer(userid)
		if not pplayer:
			continue
		now = spe.getLocVal("i", pplayer + offset)
		spe.setLocVal("i", pplayer + offset, now | value)
def hsay(users, text):
	es.usermsg("create", "hudhint", "HintText")
	es.ServerVar("temp").set(text.replace("\\", "\\\\"))
	es.usermsg("writev", "string", "hudhint", "temp")
	for userid in getusers(users):
		es.usermsg("send", "hudhint", userid)
	es.usermsg("delete", "hudhint")
def isalive(users):
	for userid in getusers(users):
		if es.getplayerprop(userid, "CBasePlayer.pl.deadflag"):
			return 0
		else:
			return 1
def isalpha(param):
	if param.isalpha():
		return 1
	else:
		return 0
def isbomber(users):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		if player.hasC4():
			return 1
		else:
			return 0
def isnumeric(param):
	if param.startswith("-"):
		param = param[1:]
	param = param.replace(".", "")
	if param.isdigit():
		return 1
	else:
		return 0
def isonly(param, checker):
	for item in param:
		if not item in checker:
			return 0
	return 1
def jetpack(users, param):
	p = int(param)
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.jetpack(p)
def kick(users, reason = ""):
	flag = 0
	if reason == "":
		flag = 1
	for userid in getusers(users):
		if flag:
			es.ServerCommand("kickid %s" % userid)
		else:
			es.ServerCommand("kickid %s %s" % (userid, reason))
def killadd(users, v):
	kills(users, "+", v)
def kills(users, param, v):
	offset = getoffsetvalue("m_iFrags")
	value = int(v)
	if param == "=":
		for userid in getusers(users):
			pplayer = spe.getPlayer(userid)
			if not pplayer:
				continue
			spe.setLocVal("i", pplayer + offset, value)
	elif param in ["+", "-"]:
		if param == "-":
			value = -value
		for userid in getusers(users):
			pplayer = spe.getPlayer(userid)
			if not pplayer:
				continue
			temp = spe.getLocVal("i", pplayer + offset)
			spe.setLocVal("i", pplayer + offset, temp + value)
def killset(users, v):
	kills(users, "=", v)
def knifeonly(users):
	for userid in getusers(users):
		if getweaponinfo(userid, 1) == ["weapon_none"] and getweaponinfo(userid, 2) == ["weapon_none"] and getweaponinfo(userid, 3) == ["weapon_knife"] and getweaponinfo(userid, 4) == ["weapon_none"]:
			return 1
		else:
			return 0
def lightstyle(style, index):
	es.lightstyle(style, index)
def loadweaponmod(filename):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	global allweapons
	global weaponmod_list
	global weaponmod_default
	path = "addons/est/%s" % filename
	test = "%s/cstrike%s" % (os.getcwd(), path)
	if fileexists(path) != 1:
		return
	item = None
	status = 0
	file = open(test)
	try:
		for line in file:
			line = line.replace("\r", "")
			line = line.replace("\n", "")
			line = line.replace("\t", "")
			line = line.replace(" ", "")
			if line == "" or line.startswith("//"):
				continue
			if "{" in line:
				status += 1
				if status != 2:
					continue
				item = None
				temp = line.split('"')
				if len(temp) != 3:
					continue
				tempitem = "weapon_%s" % temp[1]
				if not tempitem in allweapons:
					continue
				item = tempitem
				weaponmod_list[item] = weaponmod_default
				continue
			if "}" in line and status > 0:
				status -= 1
				continue
			if status == 2 and item != None:
				temp = line.split('"')
				if len(temp) != 3:
					continue
				param = temp[0]
				value = temp[1]
				temp_dic = weaponmod_list[item]
				temp_dic[param] = value
	finally:
		if file: file.close()
def loop(variable, users, command):
	for userid in getusers(users):
		es.ServerCommand("es_set %s %s" % (variable, userid))
		es.ServerCommand(command)
def modplayerweapon(users, param, value):
	global allweapons
	global modplayerweapon_list
	v = int(value)
	if not param in allweapons:
		return
	for userid in getusers(users):
		id = int(userid)
		if v == -1:
			if not id in modplayerweapon_list:
				continue
			mods = modplayerweapon_list[id]
			for item in mods:
				if item[0] == param:
					modplayerweapon_list[id].remove(item)
					break
		else:
			if not id in modplayerweapon_list:
				modplayerweapon_list[id] = []
			modplayerweapon_list[id].append([param, v])
def modweapon(param, value):
	global allweapons
	if not param in allweapons:
		return
	global modweapon_list
	v = int(value)
	if v == -1:
		if param in modweapon_list:
			del modweapon_list[param]
	else:
		modweapon_list[param] = v
def motd(users, title, type, msg):
	data = { "title":title, "type":type, "msg":msg }
	es.usermsg('create', 'panel', 'VGUIMenu')
	es.usermsg('write', 'string', 'panel', "info")
	es.usermsg('write', 'byte', 'panel', 1)
	es.usermsg('write', 'byte', 'panel', len(data))
	for item in data:
		es.usermsg('write', 'string', 'panel', item)
		es.ServerVar("temp").set(data[item].replace("\\", "\\\\"))
		es.usermsg('writev', 'string', 'panel', "temp")
	for userid in getusers(users):
		es.usermsg('send', 'panel', userid)
	es.usermsg('delete', 'panel')
def motd_f(users, title, command, path):
	motd(users, title, "3", path)
def motd_t(users, title, command, text):
	motd(users, title, "0", text)
def motd_w(users, title, command, url):
	motd(users, title, "2", url)
def msg(users, value):
	for userid in getusers(users):
		es.tell(userid, "#multi", value)
def name(users, value):
	for userid in getusers(users):
		if es.getplayersteamid(userid) == "BOT":
			es.botsetvalue(userid, "name", unicode(value))
		else:
			es.cexec(userid, "name %s" % unicode(value))
def near(variable, users, distance, baseuser, command):
	vec = es.getplayerprop(baseuser, "CBaseEntity.m_vecOrigin").split(",")
	nearcoord(variable, users, distance, float(vec[0]), float(vec[1]), float(vec[2]), command)
def nearcoord(variable, users, distance, x, y, z, command):
	filter = getusers(users)
	players = playerlib.nearCoord((float(x), float(y), float(z)), float(distance))
	for player in players:
		userid = player.userid
		if userid in filter:
			es.ServerCommand("es_set %s %s" % (variable, userid))
			es.ServerCommand(command)
def noclip(users, value):
	if int(value) == 1:
		v = 1
	else:
		v = 0
	for userid in getusers(users):
		playerlib.getPlayer(userid).noclip(v)
def openfile(flags, path):
	global file_list
	global file_handle
	if not flags in ("r", "w"): return
	test = "%s/cstrike/%s" % (os.getcwd(), path)
	if fileexists(test) != 1:
		return
	file = open(test)
	try:
		file_handle += 1
		file_list[file_handle] = [flags, test, file.readlines()]
		return file_handle
	finally:
		if file: file.close()
def physpush(users, x, y, z):
	for userid in getusers(users):
		xx = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[0]")
		yy = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[1]")
		zz = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[2]")
		vec = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity").split(",")
		es.setplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity", "%f,%f,%f" % (float(x) + float(vec[0]) - xx, float(y) + float(vec[1]) - yy, float(z) + float(vec[2]) - zz))
def play(users, param, duration = 0, volume = 1.0):
	d = float(duration)
	v = float(volume)
	for userid in getusers(users):
		es.playsound(userid, param, v)
		if d != 0:
			gamethread.delayed(d, stopsound, (userid, param))
def playedict(index, param, volume = 1.0, attenuation = 0.5):
	v = float(volume)
	a = float(attenuation)
	es.emitsound("entity", int(index), param, v, a)
def playercount(users):
	return len(getusers(users))
def playplayer(users, param, volume = 1.0, attenuation = 0.5):
	v = float(volume)
	a = float(attenuation)
	for userid in getusers(users):
		es.emitsound("player", userid, param, v, a)
def pushto(users, x, y, z, force):
	target = (float(x), float(y), float(z))
	f = float(force)
	for userid in getusers(users):
		xx = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[0]")
		yy = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[1]")
		zz = es.getplayerprop(userid, "CBasePlayer.localdata.m_vecVelocity[2]")
		source = es.getindexprop(index, "CBaseEntity.m_vecOrigin").split(",")
		base = (target[0] - float(source[0]), target[1] - float(source[1]), tartget[2] - float(source[2]))
		es.setplayerprop(userid, "CBasePlayer.localdata.m_vecBaseVelocity", "%f,%f,%f" % (base[0] * f - xx, base[1] * f - yy, base[2] * f - zz))
def randplayer(users):
	players = getusers(users)
	max = len(players)
	if max > 0:
		no = random.randint(0, max - 1)
		count = 0
		for item in players:
			if count == no:
				return item
			count += 1
	return None
def regclientcmd(command, type):
	global regclientcmd_list
	if str(type) == "1":
		t = 1
	else:
		t = 0
	for item in regclientcmd_list:
		if item[0] == command:
			regclientcmd_list.remove(item)
			break
	regclientcmd_list.append([command, t])
def regeventblock(eventname, code):
	global regeventblock_list
	if eventname in regeventblock_list:
		return
	regeventblock_list[eventname] = code
	spe.registerPreHook(eventname, hooked)
def regsayhook(text, ispartial):
	global sayhook_list
	sayhook_list[text] = int(ispartial)
def remove(param):
	es.fire(gettrigger(), str(param), "Kill")
def removeidle(param):
	if param == "weapon":
		for index in es.getEntityIndexes():
			if es.entitygetvalue(index, "classname").startswith("weapon") and es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") == -1:
				es.setentityname(index, "theweapon")
	else:
		for index in es.getEntityIndexes(param):
			if es.getindexprop(index, "CBaseCombatWeapon.m_hOwner") == -1:
				es.setentityname(index, "theweapon")
	es.fire(gettrigger(), "theweapon", "Kill")
def removeweapon(users, param):
	for userid in getusers(users):
		active = es.getindexfromhandle(es.getplayerprop(userid, "CBaseCombatCharacter.m_hActiveWeapon"))
		info = getweaponinfo(userid, param, 1)
		for index in info:
			es.setentityname(index, "theweapon")
			if active != -1 and index == active:
				es.cexec(userid, "lastinv")
	es.fire(gettrigger(), "theweapon", "Kill")
def rescued():
	global count_rescued
	return count_rescued
def restrict(users, param):
	if str(param) in ("1", "2", "3", "4"):
		return
	if str(param) == "mp5":
		param = "mp5navy"
	item = "weapon_%s" % param
	global allweapons
	if item not in allweapons:
		return
	global restrict_list, restrict_weapon_list
	for userid in getusers(users):
		if item in restrict_list.setdefault(userid, []):
			continue
		restrict_list[userid].append(item)
		restrict_weapon_list.setdefault(userid, {})
		no = 0
		name = getweaponinfo(userid, item)[0]
		if name == "weapon_hegrenade":
			no = gethe(userid)
		elif name == "weapon_smokegrenade":
			no = getsg(userid)
		elif name == "weapon_flashbang":
			no = getfb(userid)
		elif getweaponinfo(userid, param, 1) != []:
			no = 1
		if no > 0:
			restrict_weapon_list[userid][item] = no
		removeweapon(userid, item)
def restrictall(users):
	global restrict_list
	global allweapons
	for userid in getusers(users):
		for item in allweapons:
			restrict(userid, item[7:])
def rocket(users):
	# TODO: we need a beamring after explosion!
	global rocket_list
	global round_count
	es.precachemodel("sprites/muzzleflash1.vmt")
	god(users, 0)
	freeze(users, 0)
	shake(users, 10, 40, 25)
	for userid in getusers(users):
		dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
		if dead:
			continue
		rocket_list[int(userid)] = 1
		es.emitsound("player", userid, "weapons/rpg/rocketfire1.wav", 0.5, 0.5)
		gamethread.delayed(1, es.emitsound, ("player", userid, "weapons/rpg/rocket1.wav", 0.5, 0.5))
		height = float(es.getplayerprop(userid, "CBaseEntity.m_vecOrigin").split(",")[2])
		gamethread.delayed(1, rocket_loop, (userid, 0, height, height, int(round_count)))
def rocket_loop(userid, count, height, oldheight, round):
	global rocket_list
	global round_count
	global round_interval
	trigger = gettrigger()
	if round != round_count and round_interval == 0:
		return
	if int(userid) not in rocket_list:
		return
	dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
	if dead:
		es.stopsound(userid, "weapons/rpg/rocket1.wav")
		rocket_list[int(userid)] = 0
		return
	physpush(userid, 0, 0, 350)
	vec = [float(x) for x in es.getplayerprop(userid, "CBaseEntity.m_vecOrigin").split(",")]
	if vec[2] >= (height + 10) or count < 14:
		gamethread.delayed(0.1, rocket_loop, (userid, count + 1, vec[2], height, round))
		vec[0] += 120
		vec[1] += 20
		index = es.createentity("env_sprite")
		es.setindexprop(index, "CBaseEntity.m_vecOrigin", "%f,%f,%f" % (vec[0], vec[1], vec[2]))
		es.entitysetvalue(index, "model", "sprites/muzzleflash1.vmt")
		es.entitysetvalue(index, "scale", 0.4)
		es.entitysetvalue(index, "rendermode", 1)
		es.entitysetvalue(index, "renderamt", 220)
		es.spawnentity(index)
		es.setentityname(index, index)
		es.fire(trigger, index, "ShowSprite")
		for x in xrange(4):
			x += 1
			gamethread.delayed(0.05 * x, es.setindexprop, (index, "CBaseEntity.m_vecOrigin", "%f,%f,%f" % (vec[0], vec[1], vec[2] - 50 * x)))
		gamethread.delayed(0.1, es.entitysetvalue, (index, "scale", 0.2))
		gamethread.delayed(0.25, spe.removeEntityByIndex, index)
		return
	es.stopsound(userid, "weapons/rpg/rocket1.wav")
	rocket_list[int(userid)] = 0
	es.emitsound("player", userid, "weapons/hegrenade/explode3.wav", 0.5, 0.5)
	index = es.createentity("env_explosion")
	es.spawnentity(index)
	es.setentityname(index, "theexplosion")
	es.fire(trigger, "theexplosion", "addoutput", "origin %f %f %f" % (vec[0], vec[1], vec[2] + 36))
	es.fire(trigger, "theexplosion", "addoutput", "iRadiusOverride 100")
	es.fire(trigger, "theexplosion", "addoutput", "iMagnitude 1000")
	es.fire(trigger, "theexplosion", "Explode")
	spe.removeEntityByIndex(index)
	vec[0] += 120
	vec[1] += 20
	index = es.createentity("env_sprite")
	es.setindexprop(index, "CBaseEntity.m_vecOrigin", "%f,%f,%f" % (vec[0], vec[1], vec[2]))
	es.entitysetvalue(index, "model", "sprites/muzzleflash1.vmt")
	es.entitysetvalue(index, "scale", 0.4)
	es.entitysetvalue(index, "rendermode", 1)
	es.entitysetvalue(index, "renderamt", 220)
	es.spawnentity(index)
	es.setentityname(index, index)
	es.fire(trigger, index, "ShowSprite")
	for x in xrange(7):
		x += 1
		gamethread.delayed(0.1 * x, es.setindexprop, (index, "CBaseEntity.m_vecOrigin", "%f,%f,%f" % (vec[0] + 50 * x, vec[1], vec[2] - 2 * x)))
	gamethread.delayed(0.8, es.fire, (trigger, index, "Kill"))
	slay(userid)
def rounddecimal(value, places):
	v = round(float(value), int(places))
	if places == "0":
		return str(int(v))
	return str(v)
def setaim(source, target, value):
	sourceid = 0
	for userid in getusers(source):
		sourceid = userid
		break
	targetid = 0
	for userid in getusers(target):
		targetid = userid
		break
	if sourceid == 0 or targetid == 0:
		return
	player = playerlib.getPlayer(sourceid)
	player.viewPlayer(targetid)
def setammo(users, param, value):
	global ammo_list
	for userid in getusers(users):
		info = getweaponinfo(userid, param)
		for name in info:
			if name == "weapon_none":
				continue
			no = ammo_list[name]
			es.setplayerprop(userid, "CBasePlayer.localdata.m_iAmmo.%s" % no, int(value))
def setarmor(users, value):
	armor(users, "=", value)
def setcash(users, value):
	cash(users, "=", value)
def setclipammo(users, param, value):
	for userid in getusers(users):
		for index in getweaponinfo(userid, param, 1):
			es.setindexprop(index, "CBaseCombatWeapon.LocalWeaponData.m_iClip1", int(value))
def setentitycolor(index, r, g, b, a):
	color = int(r) + (int(g) << 8) + (int(b) << 16) + (int(a) << 24)
	if color >= 2**31: color -= 2**32
	es.setindexprop(index, "CBaseEntity.m_nRenderMode", es.getindexprop(index, "CBaseEntity.m_nRenderMode") | 1)
	es.setindexprop(index, "CBaseEntity.m_nRenderFX", es.getindexprop(index, "CBaseEntity.m_nRenderFX") | 256)
	es.setindexprop(index, "CBaseEntity.m_clrRender", color)
def setentmodel(index, model):
	model = model.replace("\\", "/")
	if not model.startswith("models/"):
		model = "models/%s" % model
	if not model.endswith(".mdl"):
		model += ".mdl"
	es.entitysetvalue(index, "modelindex", es.precachemodel(model))
def setentname(index, param):
	es.setentityname(index, param)
def seteventinfo(param, value):
	es.event_var[param] = value
def setgravity(users, ratio):
	for userid in getusers(users):
		index = es.getindexfromhandle(es.getplayerhandle(userid))
		es.entitysetvalue(index, "gravity", float(ratio))
def sethealth(users, value):
	health(users, "=", value)
def setmodel(users, model):
	model = model.replace("\\", "/")
	if not model.startswith("models/"):
		model = "models/%s" % model
	if not model.endswith(".mdl"):
		model += ".mdl"
	m = es.precachemodel(model)
	for userid in getusers(users):
		index = es.getindexfromhandle(es.getplayerhandle(userid))
		es.entitysetvalue(index, "modelindex", m)
def setoffset(index, property, value):
	offset = es.getpropoffset(property)
	if offset <= 0 or offset > 32768:
		return None
	pentity = spe.getEntityOfIndex(index)
	if not pentity:
		return
	type = es.getproptype(property)
	if type <= 3:
		return es.setentitypropoffset(index, offset, type)
	spe.setLocVal("i", pentity + offset, int(value))
def setplayercolor(users, r, g, b, a, weapon=0):
	if str(weapon) == "1":
		w = 1
	else:
		w = 0
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		player.setColor(int(r), int(g), int(b), int(a))
		if w == 1 and player.weapon != None:
			player.setWeaponColor(int(r), int(g), int(b), int(a))
def setviewangle(users, pitch, yaw, roll):
	for userid in getusers(users):
		es.setang(userid, pitch, yaw, roll)
def setviewcoord(users, x, y, z):
	for userid in getusers(users):
		player = playerlib.getPlayer(userid)
		pos = [x, y, z]
		player.viewCoord(pos)
def shake(users, time, distance, value):
	es.usermsg("create", "shake", "Shake")
	es.usermsg("write", "byte", "shake", 0)
	es.usermsg("write", "float", "shake", float(value))
	es.usermsg("write", "float", "shake", float(distance))
	es.usermsg("write", "float", "shake", float(time))
	for userid in getusers(users):
		es.usermsg("send", "shake", userid)
	es.usermsg("delete", "shake")
def showmenu(time, users, text):
	global round_count
	if int(time) == 0:
		count = -2
		diff = 3
	else:
		count = int(int(time) / 3)
		diff = int(int(time) % 3)
	for userid in getusers(users):
		gamethread.delayedname(0, "showmenu%d" % userid, showmenu_loop, (userid, text, count, diff))
def showmenu_loop(userid, text, count, time = 3):
	if count != -1:
		es.showMenu(time, userid, text)
		if count > -1:
			count -= 1
		gamethread.delayedname(time, "showmenu%d" % userid, showmenu_loop, (userid, text, count))
def slay(users):
	for userid in getusers(users):
		es.ServerCommand("es_sexec %d kill" % int(userid))
	gamethread.delayed(0.2, damage, (0, users, 10000))
def spawn(users, param = 0):
	gamethread.delayed(0.15, spawn_delayed, (users, param))
def spawn_delayed(users, param):
	if param == "1":
		p = 1
	else:
		p = 0
	global spawn_restrict
	for userid in getusers(users):
		if not es.getplayerprop(userid, "CBaseEntity.m_iTeamNum") in [2, 3]:
			continue
		if p:
			spe.respawn(userid)
		else:
			es.ServerCommand("es_xsetplayerprop %s CBasePlayer.m_lifeState 512" % userid)
			es.ServerCommand("es_xsetplayerprop %s CCSPlayer.m_iPlayerState 0" % userid)
			es.ServerCommand("es_xspawnplayer %s" % userid)
def speed(users, value):
	for userid in getusers(users):
		es.setplayerprop(userid, "CBasePlayer.localdata.m_flLaggedMovementValue", value)
def stopsound(users, param):
	for userid in getusers(users):
		es.stopsound(userid, param)
def stripplayer(users, param = 0):
	trigger = gettrigger()
	index = es.createentity("player_weaponstrip")
	es.setentityname(index, "thestrip")
	for userid in getusers(users):
		if str(param) != "0":
			es.fire(userid, "thestrip", "StripWeaponsAndSuit")
		else:
			es.fire(userid, "thestrip", "Strip")
	es.fire(trigger, "thestrip", "Kill")
def strlen(param):
	return len(param)
def strtolower(param):
	return param.lower()
def strtoupper(param):
	return param.upper()
def team(users, no):
	# setting CBaseEntity.m_iTeamNum is bad for bots
	if not str(no) in ["0", "1", "2", "3"]:
		return
	n = int(no)
	trigger = gettrigger()
	temp = getusers(users)
	if n > 1:
		for userid in temp:
			spe.switchTeam(userid, n)
			es.setplayerprop(userid, "CBaseEntity.m_iTeamNum", n)
	else:
		for userid in temp:
			index = es.getindexfromhandle(es.getplayerhandle(userid))
			es.entitysetvalue(index, "targetname", index)
			es.ServerCommand("es_xfire %d %d SetTeam %d" % (trigger, index, n))
def teleport(users, x, y, z):
	for userid in getusers(users):
		es.setpos(userid, float(x), float(y), float(z))
def trimdecimal(value, places):
	v = str(float(value))
	p = int(places)
	if p == 0:
		return v[0]
	return v[:p + 2]
def unhookkey(users, key):
	global in_buttons
	offset = getoffsetvalue("m_afButtonDisabled")
	if not key in in_buttons:
		return
	value = in_buttons[key]
	if str(users) == "-1":
		obj = es.getUseridList()
	else:
		obj = getusers(users)
	for userid in obj:
		pplayer = spe.getPlayer(userid)
		if not pplayer:
			continue
		now = spe.getLocVal("i", pplayer + offset)
		spe.setLocVal("i", pplayer + offset, now & (~value))
def unregclientcmd(command):
	global regclientcmd_list
	if [command, 0] in regclientcmd_list:
		regclientcmd_list.remove([command, 0])
	if [command, 1] in regclientcmd_list:
		regclientcmd_list.remove([command, 1])
def unregeventblock(eventname, code = ""):
	global regeventblock_list
	if not eventname in regeventblock_list:
		return
	del regeventblock_list[eventname]
	spe.unregisterPreHook(eventname, hooked)
def unregsayhook(text):
	global sayhook_list
	if text in sayhook_list:
		del sayhook_list[text]
def unrestrict(users, param):
	if str(param) in ("1", "2", "3", "4"):
		return
	if str(param) == "mp5":
		param = "mp5navy"
	item = "weapon_%s" % param
	global allweapons
	if item not in allweapons:
		return
	global restrict_list, restrict_weapon_list
	for userid in getusers(users):
		if item not in restrict_list.setdefault(userid, []):
			continue
		restrict_list[userid].remove(item)
		data = restrict_weapon_list.setdefault(userid, {})
		if item in data:
			no = restrict_weapon_list[userid][item]
			for i in xrange(no):
				give(userid, item)

def unrestrictall(users):
	global allweapons
	for userid in getusers(users):
		for item in allweapons:
			unrestrict(userid, item[7:])
def uptime():
	global starttime
	return time.time() - starttime

def player_activate(event_var):
	offset = getoffsetvalue("m_autoKickDisabled")
	pplayer = spe.getPlayer(int(event_var["userid"]))
	if pplayer:
		spe.setLocVal("i", pplayer + offset, 1)

def player_connect(event_var):
	global thetrigger
	global curtimed
	if curtimed == 0:
		curtimed = 1
		curtime_init()

def player_death(event_var):
	global restrict_weapon_list
	userid = int(event_var["userid"])
	if userid in restrict_weapon_list:
		del restrict_weapon_list[userid]

def pre_player_disconnect(event_var):
	global thetrigger
	global rocket_list
	userid = int(event_var["userid"])
	if thetrigger == userid:
		thetrigger = 0
	if userid in rocket_list:
		if rocket_list[userid] == 1:
			es.stopsound(userid, "weapons/rpg/rocket1.wav")

def pre_weapon_fire(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global weaponmod_list
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		auto = temp_dic["auto"]
		if auto == "0":
			return
		gamethread.delayed(0, es.setplayerprop, (userid, "CCSPlayer.cslocaldata.m_iShotsFired", 0))

def weapon_fire(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global weaponmod_list
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		recoil = temp_dic["recoil"]
		if recoil == "0":
			return
		vec = [float(x) for x in es.getplayerprop(userid, "CBasePlayer.localdata.m_Local.m_vecPunchAngle").split(",")]
		v = float(recoil) * -0.1
		temp = "%f,%f,%f" % (v, vec[1], vec[2])
		es.setplayerprop(userid, "CBasePlayer.localdata.m_Local.m_vecPunchAngle", temp)

def pre_player_hurt(event_var):
	if es.ServerVar("est_enable_weapon_mods") == 0:
		return
	userid = int(event_var["userid"])
	attacker = int(event_var["attacker"])
	if attacker == 0 or userid == 0:
		return
	item = "weapon_%s" % event_var["weapon"]
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	dmg = int(event_var["dmg_health"])
	global modplayerweapon_list
	global modweapon_list
	global weaponmod_list
	flag = 0
	if item in weaponmod_list:
		temp_dic = weaponmod_list[item]
		action = temp_dic["damageaction"]
		if not action in ("=", "+", "*"):
			return
		param = "damage%d" % event_var["hitgroup"]
		if action == "=":
			point = int(temp_dic[param])
		if action == "+":
			point = dmg + int(temp_dic[param])
		if action == "*":
			point = dmg * int(temp_dic[param])
		flag = 1
	elif attacker in modplayerweapon_list:
		mods = modplayerweapon_list[attacker]
		for mod in mods:
			if mod[0] == item:
				point = mod[1]
				flag = 1
				break
	elif item in modweapon_list:
		point = modweapon_list[item]
		flag = 1
	if flag == 0:
		return
	health = es.getplayerprop(userid, "CBasePlayer.m_iHealth")
	if point < dmg:
		es.setplayerprop(userid, "CBasePlayer.m_iHealth", health + dmg)
		if point:
			damage(attacker, userid, point)
	elif point > dmg:
		damage(attacker, userid, point - dmg)

def pre_item_pickup(event_var):
	global bought_list
	userid = event_var["userid"]
	item = event_var["item"]
	cash = es.getplayerprop(userid, "CCSPlayer.m_iAccount")
	key = "%s,%s" % (userid, item)
	bought_list[key] = cash

def item_pickup(event_var):
	global bought_list
	userid = int(event_var["userid"])
	item = event_var["item"]
	cash = es.getplayerprop(userid, "CCSPlayer.m_iAccount")
	result = item_pickup_restrict(userid, item)
	key = "%s,%s" % (userid, item)
	if key not in bought_list:
		return
	if bought_list[key] == cash:
		return
	es.event("initialize", "est_playerbought")
	es.event("setint", "est_playerbought", "userid", userid)
	es.event("setstring", "est_playerbought", "item", item)
	es.event("setint", "est_playerbought", "restricted", result)
	es.event("fire", "est_playerbought")

def item_pickup_restrict(userid, item):
	# we have to think about autobuy and rebuy
	weapon_restrictions = es.ServerVar("est_enable_weapon_restrictions")
	if not weapon_restrictions:
		return 0
	item = "weapon_%s" % item
	if item == "weapon_mp5":
		item = "weapon_mp5navy"
	global allweapons
	if not item in allweapons:
		return 0
	global restrict_list
	if item in restrict_list.setdefault(userid, []):
		removeweapon(userid, item)
		return 1
	return 0

def es_map_start(event_var):
	global round_count
	global round_interval
	global thetrigger
	thetrigger = 0
	round_count = 0
	round_interval = 0
	global buttons_list, regclientcmd_list, restrict_list, restrict_weapon_list, modplayerweapon_list, modweapon_list, weaponmod_list, regeventblock_list, rocket_list, escort_list, bought_list, sayhook_list, getchat_list, count_rescued
	buttons_list = {}
	regclientcmd_list = []
	modplayerweapon_list = {}
	modweapon_list = {}
	weaponmod_list = {}
	bought_list = {}
	sayhook_list = {}
	count_rescued = 0
	restrict_list = {}
	restrict_weapon_list = {}
	rocket_list = {}
	escort_list = {}
	getchat_list = {}
	curtime_init()

def es_client_command(event_var):
	userid = int(event_var["userid"])
	if event_var["command"] == "menuselect":
		gamethread.cancelDelayed("showmenu%d" % userid)

def round_start(event_var):
	global timer
	global round_interval
	global count_rescued
	global escort_list
	for item in escort_list:
		escort_list[item] = 0
	count_rescued = 0
	drug("#all", 0)
	round_interval = 0

def round_end(event_var):
	global round_count
	global round_interval
	round_count += 1
	round_interval = 1

def hostage_follows(event_var):
	global escort_list
	userid = int(event_var["userid"])
	escort_list.setdefault(userid, 0)
	escort_list[userid] += 1

def hostage_stops_following(event_var):
	global escort_list
	userid = int(event_var["userid"])
	escort_list.setdefault(userid, 0)
	escort_list[userid] -= 1

def hostage_rescued(event_var):
	global count_rescued
	global escort_list
	userid = int(event_var["userid"])
	escort_list.setdefault(userid, 0)
	escort_list[userid] -= 1
	count_rescued += 1

def hooked(event_var):
	global hooked_event_var
	global regeventblock_list
	eventname = event_var["spe_eventname"]
	es.addons.registerForEvent(__import__(__name__), eventname, hooked_clean)
	hooked_event_var = es.event_var
	es.event_var = event_var
	es.ServerCommand(regeventblock_list[eventname])
def hooked_clean(event_var):
	global hooked_event_var
	es.event_var = hooked_event_var

def sayfilter(userid, text, teamonly):
	# issue: from double quotation ("), all characters will be ommited
	global sayhook_list
	global getchat_list
	if userid <= 0:
		if teamonly:
			return (0, 0, 0)
		team = 0
		dead = 0
	else:
		dead = int(es.getplayerprop(userid, "CBasePlayer.pl.deadflag"))
		team = int(es.getplayerprop(userid, "CBaseEntity.m_iTeamNum"))
	flag = 0
	if text.startswith('"') and text.endswith('"'):
		rawtext = text[1:-1]
	else:
		rawtext = text
	getchat_list[userid] = rawtext
	for item in sayhook_list:
		partial = sayhook_list[item]
		if partial == 0:
			if item == rawtext:
				flag = 1
				break
		else:
			if item in rawtext:
				flag = 1
				break
	if flag == 1:
		es.event("initialize", "est_sayhook")
		es.event("setint", "est_sayhook", "userid", userid)
		es.event("setstring", "est_sayhook", "hooktext", item)
		es.event("setstring", "est_sayhook", "commandstring", text)
		es.event("setstring", "est_sayhook", "teamchat", teamonly)
		es.event("fire", "est_sayhook")
		return (0, 0, 0)
	if es.getInt("est4css_nolegacy_support"):
		return (userid, text, teamonly)
	if es.exists("saycommand", text.split(" ")[0]):
		return (userid, text, teamonly)
	gamethread.delayed(0, fake_say, (userid, rawtext))
	type = "Cstrike_Chat"
	if not dead and team in [2, 3]:
		if teamonly:
			if team == 2:
				type += "_T"
			else:
				type += "_CT"
			type += "_Loc"
		else:
			type += "_All"
		gamethread.delayed(0, sayfilter_delayed, (userid, rawtext, dead, type, teamonly))
		return (0, 0, 0)
	if teamonly:
		if team == 0:
			type += "_All"
		elif team == 2:
			type += "_T"
		elif team == 3:
			type += "_CT"
	else:
		type += "_All"
	if team == 1:
		type += "_Spec"
	elif dead:
		type += "_Dead"
	type = type.replace("All_", "All")
	gamethread.delayed(0, sayfilter_delayed, (userid, rawtext, dead, type, teamonly))
	return (0, 0, 0)

def fake_say(userid, rawtext):
	es.event("initialize", "player_say")
	es.event("setint", "player_say", "userid", userid)
	es.event("setstring", "player_say", "text", rawtext)
	es.event("fire", "player_say")

def sayfilter_delayed(userid, rawtext, dead, type, teamonly):
	if userid <= 0:
		name = steamid = teamname = "Console"
		team = 0
		userid = 0
	else:
		name = es.getplayername(userid)
		steamid = es.getplayersteamid(userid)
		team = int(es.getplayerprop(userid, "CBaseEntity.m_iTeamNum"))
		teamname = ("Unassigned", "Spectator", "TERRORIST", "CT")[team]
	es.ServerVar("temp").set('"%s<%d><%s><%s>" %s "%s"' % (name, userid, steamid, teamname, ("say", "say_team")[teamonly], rawtext))
	es.logv("temp")
	loc =""
	if type.endswith("_Loc"):
		loc = getplayerlocation(userid)
		if loc == "":
			type = type[:-4]
	teamtag = ""
	if teamonly:
		teamtag = ("", "(Spectator)", "(Terrorist)", "(Counter-Terrorist)")[team]
	else:
		if team == 1:
			teamtag = "*SPEC*"
		if team == 0 and userid > 0:
			teamtag = "*DEAD*"
	if team in [2, 3] and dead:
		teamtag = "*DEAD*%s" % teamtag
	if teamtag != "":
		teamtag = "%s " % teamtag
	if loc == "":
		base = "%s%s: %s" % (teamtag, name, rawtext)
	else:
		base = "%s%s @ %s: %s" % (teamtag, name, loc, rawtext)
	if userid == 0 or (team == 0 and teamonly):
		es.msg(base)
		return
	es.printmsg("%s\n" % base)
	es.usermsg("create", "text", "SayText2")
	es.usermsg("write", "byte", "text", es.getindexfromhandle(es.getplayerhandle(userid)))
	es.usermsg("write", "byte", "text", 1)
	es.usermsg("write", "string", "text", type)
	es.ServerVar("temp").set(name.replace("\\", "\\\\"))
	es.usermsg("writev", "string", "text", "temp")
	es.ServerVar("temp").set(rawtext.replace("\\", "\\\\"))
	es.usermsg("writev", "string", "text", "temp")
	if loc != "":
		es.usermsg("write", "string", "text", loc)
	team = 0
	if "_T" in type:
		team = 2
	elif "_CT" in type:
		team = 3
	if type == "Cstrike_Chat_All":
		for userid in es.getUseridList():
			es.usermsg("send", "text", userid)
	elif type.endswith("_Loc"):
		for userid in es.getUseridList():
			if not team or int(es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")) == team:
				es.usermsg("send", "text", userid)
	elif es.getInt("est_dead_chat") and type != "Cstrike_Chat_Spec":
		for userid in es.getUseridList():
			if not team or int(es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")) == team:
				es.usermsg("send", "text", userid)
	else:
		for userid in es.getUseridList():
			if (dead and int(es.getplayerprop(userid, "CBasePlayer.pl.deadflag"))) and (not team or int(es.getplayerprop(userid, "CBaseEntity.m_iTeamNum")) == team):
				es.usermsg("send", "text", userid)
	es.usermsg("delete", "text")

def clientcommandfilter(userid, args):
	global regclientcmd_list
	global restrict_list
	dead = es.getplayerprop(userid, "CBasePlayer.pl.deadflag")
	advanceddrop = es.ServerVar("est_allowadvanceddrop")
	weapon_restrictions = es.ServerVar("est_enable_weapon_restrictions")
	cmd = args[0].lower()
	if cmd == "kill" and not dead:
		if es.getInt("est_Hook_Kill") == 0:
			damage(userid, userid, 10000)
		return False
	flag = 0
	if weapon_restrictions:
		if advanceddrop and cmd == "drop" and not "drop" in regclientcmd_list:
			flag = 1
	else:
		if advanceddrop and cmd == "drop":
			flag = 1
	if flag == 1 and not dead:
		gun = getgun(userid)
		if gun in ["weapon_knife", "weapon_hegrenade", "weapon_flashbang", "weapon_smokegrenade"]:
			spe.dropWeapon(userid, gun)
			return False
	if cmd == "buy" and es.getplayerprop(userid, "CCSPlayer.m_bInBuyZone") and len(args) > 1 and weapon_restrictions and not dead:
		item = "weapon_%s" % args[1].lower()
		if item == "weapon_mp5":
			item = "weapon_mp5navy"
		if item in restrict_list.setdefault(userid, []):
			es.playsound(userid, "buttons/weapon_cant_buy.wav", 1.0)
			return False
	for item in regclientcmd_list:
		if item[0] == cmd:
			es.event("initialize", "est_cmdhook")
			es.event("setint", "est_cmdhook", "userid", userid)
			es.event("setstring", "est_cmdhook", "hooktext", args[0])
			if len(args) > 1:
				es.event("setstring", "est_cmdhook", "commandstring", args[1])
			else:
				es.event("setstring", "est_cmdhook", "commandstring", "")
			es.event("fire", "est_cmdhook")
			if int(item[1]) != 0: return True
			else: return False
	return True

def getweaponinfo(userid, param, getindex=0):
	if str(param) in ("1", "2", "3", "4"):
		if getindex == 1:
			return getweaponinfo2(userid, param, 1)
		return getweaponinfo2(userid, param, 0)
	v = ""
	if param.startswith("weapon_"):
		v = param
	else:
		if param == "mp5":
			param = "mp5navy"
		if param == "":
			v == "weapon_none"
		else:
			v = "weapon_%s" % param
	if getindex == 0:
		return [v]
	for no in xrange(7):
		handle = es.getplayerprop(userid, "CBaseCombatCharacter.m_hMyWeapons.%.3d" % no)
		if handle == -1:
			continue
		index = es.getindexfromhandle(handle)
		name = es.entitygetvalue(index, "classname")
		if name == v:
			return [index]
	return []

def getweaponinfo2(userid, param, getindex):
	global allprimary
	global allsecondary
	p = int(param)
	he = sg = fb = 0
	nades = []
	for no in xrange(7):
		handle = es.getplayerprop(userid, "CBaseCombatCharacter.m_hMyWeapons.%.3d" % no)
		if handle == -1:
			continue
		index = es.getindexfromhandle(handle)
		name = es.entitygetvalue(index, "classname")
		if getindex == 1:
			v = index
		else:
			v = name
		if p == 1 and name in allprimary:
			return [v]
		if p == 2 and name in allsecondary:
			return [v]
		if p == 3 and name == "weapon_knife":
			return [v]
		if p == 4:
			if getindex == 0:
				if name == "weapon_hegrenade":
					he = 1
				if name == "weapon_smokegrenade":
					sg = 1
				if name == "weapon_flashbang":
					fb = 1
			else:
				if name in ("weapon_hegrenade", "weapon_smokegrenade", "weapon_flashbang"):
					nades.append(index)
	if p == 4:
		if getindex == 0:
			if he: nades.append("weapon_hegrenade")
			if sg: nades.append("weapon_smokegrenade")
			if fb: nades.append("weapon_flashbang")
		if getindex == 1 and nades == []:
			return ["weapon_none"]
		return nades
	if getindex == 1:
		return []
	return ["weapon_none"]

def getusers(users):
	# http://www.eventscripts.com/pages/Est_PlayerSelection
	# Python style #alive, #all, #bot, #ct, #dead, #human, #spec, #t, #un
	# EST style #a, #c, #3, #t, #2, #s, #1, #u, #0, #h, #b, #l, #d
	# ex1: #alive,#ct (for CT who is alive)
	# ex2: #23!d (for all T and CT who is alive)
	# issue: names start with # are not supported
	global pyfilter
	if str(users).startswith("#"):
		status = 0
		notfilter = ""
		if "," in users:
			status = 1
		if "!" in users:
			all = users.split("!")
			users = all[0]
			notfilter = all[1]
			status = 2
		if status == 0:
			if users in pyfilter:
				status = 1
			else:
				status = 2
		if status == 2:
			global filter_table
			filter = []
			for item in filter_table:
				if item[0] in users:
					idlist = playerlib.getUseridList(item[1])
					filter.extend(idlist)
			users = set(filter)
			if notfilter != "":
				filter = []
				for item in filter_table:
					if item[0] in notfilter:
						idlist = playerlib.getUseridList(item[1])
						filter.extend(idlist)
				notfilter = set(filter)
				for item in notfilter:
					if int(item) in users:
						users.remove(int(item))
		else:
			users = playerlib.getUseridList(users)
	else:
		test = []
		if isinstance(users, tuple) or isinstance(users, list):
			test = users
		else:
			test.append(users)
		users = []
		for user in test:
			id = es.getuserid(user)
			if id:
				users.append(id)
	return users

def estfilter(users):
	if not str(users).startswith("#"):
		return users
	users = users.replace("t", "2")
	users = users.replace("c", "3")
	return users

def unicode(text):
	# for unicode texts in usermsg
	status = 0
	if text.count("/") <= 1:
		status = 0
		error = ":; ()'\\"
		for item in error:
			if item in text:
				status = 1
				break
	else:
		status = 1
	if status:
		msg = text
	else:
		msg = '"%s"' % text
	return msg

def gettrigger():
	global thetrigger
	if thetrigger != 0:
		return thetrigger
	for userid in es.getUseridList():
		if es.getplayersteamid(userid) != "BOT":
			thetrigger = userid
			return userid
	return es.getuserid()

def getoffsetvalue(property):
	global offsets
	return offsets[property]

def est_client_keypress(userid, status, key):
	es.event("initialize", "est_client_keypress")
	es.event("setint", "est_client_keypress", "userid", userid)
	es.event("setint", "est_client_keypress", "status", status)
	es.event("setstring", "est_client_keypress", "keyname", key)
	es.event("fire", "est_client_keypress")

def ticklistener():
	if not es.ServerVar("est_enable_PerUserKeyEvents"):
		return
	global in_buttons
	for userid in es.getUseridList():
		pplayer = spe.getPlayer(userid)
		if not pplayer:
			continue
		offset = getoffsetvalue("m_nButtons")
		now = spe.getLocVal("i", pplayer + offset)
		if userid not in buttons_list:
			buttons_list[userid] = now
		for key in in_buttons:
			if in_buttons[key] & now and in_buttons[key] & ~buttons_list[userid]:
				est_client_keypress(userid, 1, key)
			elif in_buttons[key] & ~now and in_buttons[key] & buttons_list[userid]:
				est_client_keypress(userid, 0, key)
		buttons_list[userid] = now